document.addEventListener('DOMContentLoaded', () => {
    const powerBtn = document.getElementById('powerButtonContainer');
    const botStatus = document.getElementById('botStatus');
    const flashcardContainer = document.getElementById('flashcard-container');
    const expiryDisplay = document.getElementById('expiryTimer');
    const renewBtnInfo = document.getElementById('renew-key-info');

    // CORRECTED URL
    const SELLAUTH_URL = "https://smarterbook.mysellauth.com";

    // 1. Matrix Background
    const canvas = document.getElementById('bgCanvas');
    const ctx = canvas.getContext('2d');
    canvas.width = 300; canvas.height = 500;
    const drops = Array(30).fill(1);
    setInterval(() => {
        ctx.fillStyle = "rgba(6, 6, 12, 0.1)"; ctx.fillRect(0, 0, 300, 500);
        ctx.fillStyle = "#38c172"; ctx.font = "10px monospace";
        drops.forEach((y, i) => {
            ctx.fillText(Math.random() > 0.5 ? "0" : "1", i * 10, y * 10);
            if (y * 10 > 500 && Math.random() > 0.975) drops[i] = 0;
            drops[i]++;
        });
    }, 50);

    // 2. Load Vault
    function loadVault() {
        chrome.storage.local.get(['responseMap'], (res) => {
            const map = res.responseMap || {};
            const keys = Object.keys(map);
            flashcardContainer.innerHTML = keys.length ? '' : '<p style="font-size:0.65em; color:#4b5563; text-align:center; margin-top: 40px;">VAULT EMPTY</p>';
            keys.reverse().forEach(q => {
                const card = document.createElement('div');
                card.className = 'flashcard';
                card.innerHTML = `<div class="fc-q">${q}</div><div class="fc-a">${map[q]}</div>`;
                card.onclick = () => card.classList.toggle('flipped');
                flashcardContainer.appendChild(card);
            });
        });
    }

    // 3. Navigation
    document.querySelectorAll('.nav-item').forEach(item => {
        item.onclick = () => {
            const target = item.id.replace('nav-', '') + '-tab';
            document.querySelectorAll('.tab-content').forEach(t => t.classList.remove('active'));
            document.querySelectorAll('.nav-item').forEach(n => n.classList.remove('active'));
            document.getElementById(target).classList.add('active');
            item.classList.add('active');
            if(target === 'data-tab') loadVault();
        };
    });

    // 4. Power Button
    powerBtn.onclick = () => {
        chrome.storage.local.get(['enabled'], (res) => {
            const newState = !res.enabled;
            chrome.storage.local.set({ enabled: newState }, () => {
                updateUI(newState);
                chrome.tabs.query({active: true, currentWindow: true}, (tabs) => {
                    if (tabs[0]) chrome.tabs.sendMessage(tabs[0].id, newState ? "activate" : "deactivate");
                });
            });
        });
    };

    function updateUI(enabled) {
        powerBtn.classList.toggle('on', enabled);
        botStatus.textContent = enabled ? "SYSTEM: ACTIVE" : "SYSTEM: OFF";
        botStatus.style.color = enabled ? "#38c172" : "#4b5563";
    }

    // 5. DETACH BUTTON
    document.getElementById('detach-ui').onclick = () => {
        chrome.windows.create({
            url: chrome.runtime.getURL("index.html"),
            type: "popup", width: 316, height: 539
        });
    };

    // 6. Expiry Logic
    function startTimer(expiry) {
        const update = () => {
            const diff = expiry - Date.now();
            if (diff <= 0) {
                expiryDisplay.textContent = "EXPIRED";
                return;
            }
            const d = Math.floor(diff / (1000 * 60 * 60 * 24));
            const h = Math.floor((diff / (1000 * 60 * 60)) % 24);
            const m = Math.floor((diff / 1000 / 60) % 60);
            expiryDisplay.textContent = `${d}d ${h}h ${m}m`;
        };
        update();
        setInterval(update, 60000);
    }

    // 7. All SellAuth Links
    document.getElementById('get-key-url').onclick = () => window.open(SELLAUTH_URL, "_blank");
    renewBtnInfo.onclick = () => window.open(SELLAUTH_URL, "_blank");

    // Clear Data
    document.getElementById('clear-vault').onclick = () => {
        if(confirm("Clear all captured answers?")) {
            chrome.storage.local.set({responseMap: {}}, loadVault);
        }
    };

    // License Activation
    document.getElementById('verify-btn').onclick = () => {
        const key = document.getElementById('license-key').value.trim();
        chrome.runtime.sendMessage({ type: "VERIFY_KEY", key: key }, (res) => {
            if (res?.success) {
                chrome.storage.local.set({ isLicensed: true, expiry: res.expiry }, () => location.reload());
            } else {
                const error = document.getElementById('auth-error');
                error.style.display = "block";
                error.textContent = res?.message || "INVALID KEY";
            }
        });
    };

    // Init
    chrome.storage.local.get(['enabled', 'isLicensed', 'expiry'], (res) => {
        if (!res.isLicensed || res.expiry < Date.now()) {
            document.getElementById('auth-screen').style.display = 'flex';
        } else {
            startTimer(res.expiry);
        }
        updateUI(res.enabled);
        loadVault();
    });

    chrome.storage.onChanged.addListener((changes) => {
        if (changes.enabled) updateUI(changes.enabled.newValue);
    });
});